/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="magnetism")
public class RitualMagnetic
extends Ritual {
    public static final String PLACEMENT_RANGE = "placementRange";
    public BlockPos lastPos;
    private FakePlayer fakePlayer;

    public RitualMagnetic() {
        super("ritualMagnetic", 0, 5000, "ritual.bloodmagic.magneticRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        Vec3 MRSpos = new Vec3((double)masterRitualStone.getMasterBlockPos().m_123341_(), (double)masterRitualStone.getMasterBlockPos().m_123342_(), (double)masterRitualStone.getMasterBlockPos().m_123343_());
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor placementRange = masterRitualStone.getBlockRange(PLACEMENT_RANGE);
        BlockPos replacement = pos;
        boolean replace = false;
        for (BlockPos offset : placementRange.getContainedPositions(pos)) {
            if (!world.m_46859_(offset)) continue;
            replacement = offset;
            replace = true;
            break;
        }
        BlockState downState = world.m_8055_(pos.m_7495_());
        int radius = this.getRadius(downState.m_60734_());
        int maxBlockChecks = 100;
        int checks = 0;
        if (replace) {
            int j = -1;
            int i = -radius;
            int k = -radius;
            if (this.lastPos != null && !this.lastPos.equals((Object)BlockPos.f_121853_)) {
                j = this.lastPos.m_123342_();
                i = Math.min(radius, Math.max(-radius, this.lastPos.m_123341_()));
                k = Math.min(radius, Math.max(-radius, this.lastPos.m_123343_()));
            }
            while (j + pos.m_123342_() >= world.m_141937_()) {
                while (i <= radius) {
                    while (k <= radius) {
                        if (checks >= maxBlockChecks) {
                            this.lastPos = new BlockPos(i, j, k);
                            return;
                        }
                        ++checks;
                        BlockPos newPos = pos.m_142082_(i, j, k);
                        Vec3 newPosVector = new Vec3((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_());
                        BlockState state = world.m_8055_(newPos);
                        ItemStack checkStack = new ItemStack((ItemLike)state.m_60734_());
                        if (RitualMagnetic.isBlockOre(checkStack)) {
                            Utils.swapLocations(world, newPos, world, replacement);
                            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                            this.lastPos = new BlockPos(i, j, ++k);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                    k = -radius;
                }
                --j;
                i = -radius;
            }
            j = -1;
            this.lastPos = new BlockPos(i, j, k);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.lastPos = new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.lastPos != null) {
            tag.m_128405_("xCoord", this.lastPos.m_123341_());
            tag.m_128405_("yCoord", this.lastPos.m_123342_());
            tag.m_128405_("zCoord", this.lastPos.m_123343_());
        }
    }

    public int getRadius(Block block) {
        if (block == Blocks.f_50075_) {
            return 7;
        }
        if (block == Blocks.f_50074_) {
            return 15;
        }
        if (block == Blocks.f_50090_) {
            return 31;
        }
        return 3;
    }

    @Override
    public int getRefreshTime() {
        return 40;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 2, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMagnetic();
    }

    private FakePlayer getFakePlayer(ServerLevel world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_magnetic"))) : this.fakePlayer;
    }

    public static boolean isBlockOre(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_204117_(Tags.Items.ORES);
    }
}

